'/***
'*search.h - declarations for searching/sorting routines
'*
'*       Copyright (c) 1985-1997, Microsoft Corporation. All rights reserved.
'*
'*Purpose:
'*       This file contains the declarations for the sorting and
'*       searching routines.
'*       [System V]
'*
'*       [Public]
'*
'****/

#If Not %Def(%SEARCH_INC)
    %SEARCH_INC = 1

'typedef unsigned int size_t;

'/* Function prototypes */

'_CRTIMP void * __cdecl bsearch(const void *, const void *, size_t, size_t,
'        int (__cdecl *)(const void *, const void *));
Declare Function bsearch CDecl Lib "msvcrt.dll" Alias "bsearch" ( _
   ByVal Dword, _                           ' const void *key
   ByVal Dword, _                           ' const void *base
   ByVal Dword, _                           ' size_t num
   ByVal Dword, _                           ' size_t width
   ByVal Dword _                            ' int ( __cdecl *compare ) ( const void *, const void *)
   ) As Dword                               ' void *

'_CRTIMP void * __cdecl _lfind(const void *, const void *, unsigned int *, unsigned int,
'        int (__cdecl *)(const void *, const void *));
Declare Function lfind CDecl Lib "msvcrt.dll" Alias "_lfind" ( _
   ByVal Dword, _                           ' const void *key
   ByVal Dword, _                           ' const void *base
   ByRef Dword, _                           ' unsigned int *num
   ByVal Dword, _                           ' unsigned int width
   ByVal Dword _                            ' int (__cdecl *compare)(const void *, const void *)
   ) As Dword                               ' void *

'_CRTIMP void * __cdecl _lsearch(const void *, void  *, unsigned int *, unsigned int,
'        int (__cdecl *)(const void *, const void *));
Declare Function lsearch CDecl Lib "msvcrt.dll" Alias "_lsearch" ( _
   ByVal Dword, _                           ' const void *key
   ByVal Dword, _                           ' const void *base
   ByRef Dword, _                           ' unsigned int *num
   ByVal Dword, _                           ' unsigned int width
   ByVal Dword _                            ' int (__cdecl *compare)(const void *, const void *)
   ) As Dword                               ' void *

'_CRTIMP void __cdecl qsort(void *, size_t, size_t, int (__cdecl *)(const void *,
'        const void *));
Declare Sub qsort CDecl Lib "msvcrt.dll" Alias "qsort" ( _
   ByVal Dword, _                           ' void *base
   ByVal Dword, _                           ' size_t num
   ByVal Dword, _                           ' size_t width
   ByVal Dword _                            ' int (__cdecl *compare )(const void *, const void *)
   )                                        ' void


#EndIf   ' #IF NOT %DEF(%SEARCH_INC)